<?php
$query_array=array("10"=>array("headline"=>__("Other Items Discovered in the last")." $other_detected ".__("Days"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                        "sql"=>"
                                                                SELECT other_id, other_ip_address, other_network_name, other_type, other_description
                                                                FROM other
                                                                WHERE (other_mac_address <> '' AND other_first_timestamp > '" . adjustdate(0,0,-$other_detected) . "') ",
                                                        "sort"=>"other_ip_address",
                                                        "show"=>$show_other_discovered,
                                                        "get"=>array("file"=>"system.php",
                                                                     "title"=>__("Go to System"),
                                                                     "var"=>array("other"=>"%other_id",
                                                                                  "view"=>"other_system",
                                                                                 ),
                                                                     ),
                                                        "fields"=>array("10"=>array("name"=>"other_id",
                                                                                    "head"=>__("UUID"),
                                                                                    "show"=>"n"
                                                                                    ),
                                                                        "20"=>array("name"=>"other_ip_address",
                                                                                    "head"=>__("IP"),
                                                                                    "link"=>"y",
                                                                                    ),
                                                                        "30"=>array("name"=>"other_network_name",
                                                                                    "head"=>__("Hostname"),
                                                                                    "link"=>"y",
                                                                                    ),
                                                                        "40"=>array("name"=>"other_type",
                                                                                    "head"=>__("Type"),
                                                                                    ),
                                                                        "50"=>array("name"=>"other_description",
                                                                                    "head"=>__("Description"),
                                                                                    ),
                                                                       ),
                                                         ),
                                             ),
                              ),
/********************************************************************************************************************************/
                   "20"=>array("headline"=>__("Systems Discovered in the last")." $system_detected ".__("Days"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "sql"=>"
                                                            SELECT system_uuid, net_ip_address, system_name, system_os_name, system_timestamp, system_system_type, system_description, net_domain, system_service_pack
                                                            FROM system
                                                            WHERE system_first_timestamp > '" . adjustdate(0,0,-$system_detected) . "000000'  ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_system_discovered,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"system_os_name",
                                                                                "head"=>__("OS"),
                                                                                "show"=>$show_os,
                                                                               ),
                                                                    "50"=>array("name"=>"system_timestamp",
                                                                                "head"=>__("Date Discovered"),
                                                                                "show"=>$show_date_audited,
                                                                               ),
                                                                    "60"=>array("name"=>"system_system_type",
                                                                                "head"=>__("System Type"),
                                                                                "show"=>$show_type,
                                                                                "align"=>"center",
                                                                               ),
                                                                    "70"=>array("name"=>"system_description",
                                                                                "head"=>__("Description"),
                                                                                "show"=>$show_description,
                                                                               ),
                                                                    "80"=>array("name"=>"net_domain",
                                                                                "head"=>__("Domain"),
                                                                                "show"=>$show_domain,
                                                                               ),
                                                                    "90"=>array("name"=>"system_service_pack",
                                                                                "head"=>__("Servicepack"),
                                                                                "show"=>$show_service_pack,
                                                                                    ),
                                                                       ),
                                                         ),
                                             ),
                              ),
/********************************************************************************************************************************/
                   "30"=>array("headline"=>__("Systems Not Discovered in the last")." $days_systems_not_audited ".__("Days"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "sql"=>"
                                                            SELECT system_uuid, net_ip_address, system_name, system_os_name, system_timestamp, system_system_type, system_description, net_domain, system_service_pack
                                                            FROM system
                                                            WHERE system_timestamp < '" . adjustdate(0,0,-$days_systems_not_audited) . "000000' ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_systems_not_audited,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"system_os_name",
                                                                                "head"=>__("OS"),
                                                                                "show"=>$show_os,
                                                                               ),
                                                                    "50"=>array("name"=>"system_timestamp",
                                                                                "head"=>__("Date Discovered"),
                                                                                "show"=>$show_date_audited,
                                                                               ),
                                                                    "60"=>array("name"=>"system_system_type",
                                                                                "head"=>__("System Type"),
                                                                                "show"=>$show_type,
                                                                                "align"=>"center",
                                                                               ),
                                                                    "70"=>array("name"=>"system_description",
                                                                                "head"=>__("Description"),
                                                                                "show"=>$show_description,
                                                                               ),
                                                                    "80"=>array("name"=>"net_domain",
                                                                                "head"=>__("Domain"),
                                                                                "show"=>$show_domain,
                                                                               ),
                                                                    "90"=>array("name"=>"system_service_pack",
                                                                                "head"=>__("Servicepack"),
                                                                                "show"=>$show_service_pack,
                                                                                    ),
                                                                       ),
                                                         ),
                                             ),
                              ),
/********************************************************************************************************************************/
                   "40"=>array("headline"=>__("Partition free space less than")." ".$partition_free_space." ".__("MB"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "sql"=>"
                                                            SELECT system_uuid, system_name, net_ip_address, partition_uuid, partition_volume_name,
                                                            partition_caption, partition_free_space, partition_size, partition_timestamp
                                                            FROM system sys, `partition` par
                                                            WHERE partition_free_space < '$partition_free_space'
                                                            AND system_uuid = partition_uuid AND partition_timestamp = system_timestamp
                                                           ",
                                                    "sort"=>"partition_free_space",
                                                    "show"=>$show_partition_usage,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"partition_free_space",
                                                                                "head"=>__("Free Space"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                                    "50"=>array("name"=>"partition_size",
                                                                                "head"=>__("Size"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                                    "60"=>array("name"=>"partition_caption",
                                                                                "head"=>__("Drive Letter"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                                "align"=>"center",
                                                                               ),
                                                                    "70"=>array("name"=>"partition_volume_name",
                                                                                "head"=>__("Description"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                                    ),
                                                                       ),
                                                         ),
                                             ),
                              ),
/********************************************************************************************************************************/
                   "50"=>array("headline"=>__("Software detected in the last")." ".$days_software_detected." ".__("Days"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "sql"=>"
                                                            SELECT software_name, software_first_timestamp, system_name, system_uuid, net_ip_address
                                                            FROM software sw, system sys
                                                            WHERE software_first_timestamp >= '" . adjustdate(0,0,-$days_software_detected) . "000000'
                                                            AND system_first_timestamp < '" . adjustdate(0,0,-$days_software_detected) . "000000'
                                                            AND software_name NOT LIKE '%Hotfix%' AND software_name NOT LIKE '%Update%' AND
                                                            software_uuid = system_uuid
                                                           ",
                                                    "sort"=>"software_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"software_first_timestamp",
                                                                                "head"=>__("Date Discovered"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                                    "50"=>array("name"=>"software_name",
                                                                                "head"=>__("Name"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                                "get"=>array("file"=>"list.php",
                                                                                             "title"=>__("Systems installed this Software"),
                                                                                             "var"=>array("name"=>"%software_name",
                                                                                                          "view"=>"systems_for_software",
                                                                                                          "headline_addition"=>"%software_name",
                                                                                                          ),
                                                                                    ),
                                                                       ),
                                                         ),
                                             ),
                              ),
                   ),
/********************************************************************************************************************************/
                   "60"=>array("headline"=>__("WEB Servers"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "headline"=>__("On Discovered Hosts by Windowsservice"),
                                                    "sql"=>"
                                                            SELECT system_uuid, service_uuid, service_display_name, service_started, system_name, net_ip_address
                                                            FROM service, system
                                                            WHERE (service_display_name LIKE 'IIS Admin%' OR service_display_name LIKE 'Apache%') AND
                                                            service_uuid = system_uuid AND
                                                            service_timestamp = system_timestamp
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"service_display_name",
                                                                                "head"=>__("Service"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                                    "50"=>array("name"=>"service_started",
                                                                                "head"=>__("Running"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                         ),
                                             ),
                                              "20"=>array(
                                                    "headline"=>__("On Discovered Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT net_ip_address, system_name, system_uuid
                                                            FROM system, nmap_ports
                                                            WHERE nmap_port_number = '80' AND nmap_other_id = system_uuid
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                                              "30"=>array(
                                                    "headline"=>__("On other Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT other_id, other_ip_address, other_network_name, other_mac_address
                                                            FROM other, nmap_ports
                                                            WHERE nmap_port_number = '80' AND
                                                            (nmap_other_id = other_mac_address OR nmap_other_id = other_id)
                                                           ",
                                                    "sort"=>"other_network_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("other"=>"%other_id",
                                                                              "view"=>"other_system",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"other_id",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"other_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"other_network_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                              ),
                   ),
/********************************************************************************************************************************/
                   "70"=>array("headline"=>__("FTP Servers"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "headline"=>__("On Discovered Hosts by Windowsservice"),
                                                    "sql"=>"
                                                            SELECT service_uuid, service_display_name, service_started, system_name, net_ip_address
                                                            FROM service, system
                                                            WHERE service_display_name = 'FTP Publishing Service' AND
                                                            service_uuid = system_uuid AND
                                                            service_timestamp = system_timestamp
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"service_display_name",
                                                                                "head"=>__("Service"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                                    "50"=>array("name"=>"service_started",
                                                                                "head"=>__("Running"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                         ),
                                             ),
                                              "20"=>array(
                                                    "headline"=>__("On Discovered Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT net_ip_address, system_name, system_uuid
                                                            FROM system, nmap_ports
                                                            WHERE nmap_port_number = '21' AND nmap_other_id = system_uuid
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                                              "30"=>array(
                                                    "headline"=>__("On other Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT other_id, other_ip_address, other_network_name, other_mac_address
                                                            FROM other, nmap_ports
                                                            WHERE nmap_port_number = '21' AND
                                                            (nmap_other_id = other_mac_address OR nmap_other_id = other_id)
                                                           ",
                                                    "sort"=>"other_network_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("other"=>"%other_id",
                                                                              "view"=>"other_system",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"other_id",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"other_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"other_network_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                              ),
                   ),
/********************************************************************************************************************************/
                   "80"=>array("headline"=>__("Telnet Servers"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "headline"=>__("On Discovered Hosts by Windowsservice"),
                                                    "sql"=>"
                                                            SELECT system_uuid,service_uuid, service_display_name, service_started, system_name, net_ip_address
                                                            FROM service, system
                                                            WHERE service_display_name = 'Telnet' AND
                                                            service_uuid = system_uuid AND
                                                            service_timestamp = system_timestamp
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"service_display_name",
                                                                                "head"=>__("Service"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                                    "50"=>array("name"=>"service_started",
                                                                                "head"=>__("Running"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                         ),
                                             ),
                                              "20"=>array(
                                                    "headline"=>__("On Discovered Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT net_ip_address, system_name, system_uuid
                                                            FROM system, nmap_ports
                                                            WHERE nmap_port_number = '23' AND nmap_other_id = system_uuid
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                                              "30"=>array(
                                                    "headline"=>__("On other Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT other_id, other_ip_address, other_network_name, other_mac_address
                                                            FROM other, nmap_ports
                                                            WHERE nmap_port_number = '23' AND
                                                            (nmap_other_id = other_mac_address OR nmap_other_id = other_id)
                                                           ",
                                                    "sort"=>"other_network_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%other_id",
                                                                              "view"=>"other_system",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"other_id",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"other_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"other_network_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                              ),
                   ),
/********************************************************************************************************************************/
                   "90"=>array("headline"=>__("Email Servers"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "headline"=>__("On Discovered Hosts by Windowsservice"),
                                                    "sql"=>"
                                                           SELECT system_uuid, service_uuid, service_display_name, service_started, system_name, net_ip_address FROM service, system WHERE
                                                           (service_display_name = 'Microsoft Exchange Information Store' OR
                                                           service_display_name = 'Simple Mail Transport Protocol (SMTP)' OR
                                                           service_display_name LIKE 'Lotus Domino%' OR
                                                           service_display_name = 'Simple Mail Transfer Protocol (SMTP)')
                                                           AND service_timestamp = system_timestamp AND service_uuid = system_uuid
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"service_display_name",
                                                                                "head"=>__("Service"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                                    "50"=>array("name"=>"service_started",
                                                                                "head"=>__("Running"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                         ),
                                             ),
                                              "20"=>array(
                                                    "headline"=>__("On Discovered Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT net_ip_address, system_name, system_uuid
                                                            FROM system, nmap_ports
                                                            WHERE nmap_port_number = '25' AND nmap_other_id = system_uuid
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                                              "30"=>array(
                                                    "headline"=>__("On other Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT other_id, other_ip_address, other_network_name, other_mac_address
                                                            FROM other, nmap_ports
                                                            WHERE nmap_port_number = '25' AND
                                                            (nmap_other_id = other_mac_address OR nmap_other_id = other_id)
                                                           ",
                                                    "sort"=>"other_network_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%other_id",
                                                                              "view"=>"other_system",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"other_id",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"other_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"other_network_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                              ),
                   ),
/********************************************************************************************************************************/
                   "100"=>array("headline"=>__("Active VNC Servers"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "headline"=>__("On Discovered Hosts by Windowsservice"),
                                                    "sql"=>"
                                                           SELECT system_uuid, service_uuid, service_display_name, service_started, system_name, net_ip_address FROM service, system
                                                           WHERE
                                                           service_display_name LIKE '%VNC%' AND
                                                           service_timestamp = system_timestamp AND service_uuid = system_uuid
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"service_display_name",
                                                                                "head"=>__("Service"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                                    "50"=>array("name"=>"service_started",
                                                                                "head"=>__("Running"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                         ),
                                             ),
                                              "20"=>array(
                                                    "headline"=>__("On Discovered Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT net_ip_address, system_name, system_uuid
                                                            FROM system, nmap_ports
                                                            WHERE nmap_port_number = '5900' AND nmap_other_id = system_uuid
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                                              "30"=>array(
                                                    "headline"=>__("On other Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT other_id, other_ip_address, other_network_name, other_mac_address
                                                            FROM other, nmap_ports
                                                            WHERE nmap_port_number = '5900' AND
                                                            (nmap_other_id = other_mac_address OR nmap_other_id = other_id)
                                                           ",
                                                    "sort"=>"other_network_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%other_id",
                                                                              "view"=>"other_system",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"other_id",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"other_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"other_network_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                              ),
                   ),
/********************************************************************************************************************************/
                   "110"=>array("headline"=>__("Active RDP or Terminal Servers"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "headline"=>__("On Discovered Hosts by Windowsservice"),
                                                    "sql"=>"
                                                           SELECT system_uuid, service_uuid, service_display_name, service_started, system_name, net_ip_address
                                                           FROM service, system
                                                           WHERE
                                                           service_display_name LIKE '%Terminal%' AND
                                                           service_timestamp = system_timestamp AND service_uuid = system_uuid
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"service_display_name",
                                                                                "head"=>__("Service"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                                    "50"=>array("name"=>"service_started",
                                                                                "head"=>__("Running"),
                                                                                "show"=>"y",
                                                                                "link"=>"n",
                                                                               ),
                                                         ),
                                             ),
                                              "20"=>array(
                                                    "headline"=>__("On Discovered Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT net_ip_address, system_name, system_uuid
                                                            FROM system, nmap_ports
                                                            WHERE nmap_port_number = '3389' AND nmap_other_id = system_uuid
                                                           ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                                              "30"=>array(
                                                    "headline"=>__("On other Hosts by Portscan"),
                                                    "sql"=>"
                                                            SELECT other_id, other_ip_address, other_network_name, other_mac_address
                                                            FROM other, nmap_ports
                                                            WHERE nmap_port_number = '3389' AND
                                                            (nmap_other_id = other_mac_address OR nmap_other_id = other_id)
                                                           ",
                                                    "sort"=>"other_network_name",
                                                    "show"=>$show_software_detected,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%other_id",
                                                                              "view"=>"other_system",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"other_id",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"other_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"other_network_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                         ),
                                             ),
                              ),
                   ),
/********************************************************************************************************************************/
                   "120"=>array("headline"=>__("XP SP2 without up to date AntiVirus"),
                               "td_width"=>array("130"),
                               "views"=>array(
                                              "10"=>array(
                                                    "sql"=>"
                                                            SELECT system_name, net_ip_address, system_uuid, virus_name, virus_uptodate
                                                            FROM system
                                                            WHERE (virus_name = '' OR virus_uptodate = 'False') AND system_service_pack = '2.0' AND system_os_name LIKE 'Microsoft Windows XP%'
                                                            ",
                                                    "sort"=>"system_name",
                                                    "show"=>$show_system_discovered,
                                                    "get"=>array("file"=>"system.php",
                                                                 "title"=>__("Go to System"),
                                                                 "var"=>array("pc"=>"%system_uuid",
                                                                              "view"=>"summary",
                                                                             ),
                                                                 ),
                                                    "fields"=>array("10"=>array("name"=>"system_uuid",
                                                                                "head"=>__("UUID"),
                                                                                "show"=>"n",
                                                                               ),
                                                                    "20"=>array("name"=>"net_ip_address",
                                                                                "head"=>__("IP"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "30"=>array("name"=>"system_name",
                                                                                "head"=>__("Hostname"),
                                                                                "show"=>"y",
                                                                                "link"=>"y",
                                                                               ),
                                                                    "40"=>array("name"=>"virus_name",
                                                                                "head"=>__("AntiVirus Program"),
                                                                               ),
                                                                    "50"=>array("name"=>"virus_uptodate",
                                                                                "head"=>__("AntiVirus Up To Date"),
                                                                               ),
                                                                       ),
                                                         ),
                                             ),
                              ),
);
?>
