<?php
include_once("session.php");
include_once("header.php");
include_once("nav.php");

$act = $post_vars['act'];

class ibackupClose {
	function debug($array) {
		echo '<pre>';
		print_r($array);
		echo '</pre>';
	}

	function extractName($string) {
		$select_tag = 'Computer Name';
		$lines = explode("\n", $string);
		
		foreach ($lines as $line) {
			if (strpos($line, $select_tag) !== FALSE) {
				$match = explode(':', $line);
				return trim($match[1]);
			}
		}
		
		return false;
	}
	function extractJDName($_html, $supp_obj, $columns = 'Computer') {
		$html = $supp_obj->strip_html($_html, '<br><p><ul><li><ol><a><table><td><tr><thead><tfoot><th>');
		$dom = new DOMDocument();
		$dom->strictErrorChecking = false;
		$dom->preserveWhiteSpace = false; 
		$dom->loadHTML($html);
		$tables = $dom->getElementsByTagName('table');
		if($tables->length > 0) {
			$Header = $dom->getElementsByTagName('th');
			$Detail = $dom->getElementsByTagName('td');
			//$this->debug($Detail);
			//#Get header name of the table
			foreach($Header as $NodeHeader) {
				$aDataTableHeaderHTML[] = trim($NodeHeader->textContent);
			}
			//print_r($aDataTableHeaderHTML); die();
		
			//#Get row data/detail table without header name as key
			$i = 0;
			$j = 0;
			foreach($Detail as $sNodeDetail) {
				$aDataTableDetailHTML[$j][] = trim($sNodeDetail->textContent);
				$i = $i + 1;
				$j = $i % count($aDataTableHeaderHTML) == 0 ? $j + 1 : $j;
			}
			//print_r($aDataTableDetailHTML); die();
			
			//#Get row data/detail table with header name as key and outer array index as row number
			for($i = 0; $i < count($aDataTableDetailHTML); $i++) {
				for($j = 0; $j < count($aDataTableHeaderHTML); $j++) {
					if($aDataTableHeaderHTML[$j] == $columns) {
						$aTempData[$i] = $aDataTableDetailHTML[$i][$j];
					}
				}
			}

			//$this->debug($Detail);
			return $aTempData;
		}
		
		return false;
	}
	function extractJDReply($_html, $supp_obj) {
		$html = $supp_obj->strip_html($_html, '<br><p><ul><li><ol><a><table><td><tr><thead><tfoot><th>');
		$dom = new DOMDocument();
		$dom->strictErrorChecking = false;
		$dom->preserveWhiteSpace = false; 
		$dom->loadHTML(mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8'));
		$tables = $dom->getElementsByTagName('table');
		
		if ($tables->length > 0) {
			$Header = $dom->getElementsByTagName('th');
			$Detail = $dom->getElementsByTagName('td');
		
			//#Get header name of the table
			foreach($Header as $NodeHeader) {
				$aDataTableHeaderHTML[] = trim($NodeHeader->textContent);
			}
			//print_r($aDataTableHeaderHTML); die();
		
			//#Get row data/detail table without header name as key
			$i = 0;
			$j = 0;
			foreach($Detail as $sNodeDetail)  {
				$aDataTableDetailHTML[$j][] = trim($sNodeDetail->textContent);
				$i = $i + 1;
				$j = $i % count($aDataTableHeaderHTML) == 0 ? $j + 1 : $j;
			}
			//print_r($aDataTableDetailHTML); die();
			
			//#Get row data/detail table with header name as key and outer array index as row number
			for($i = 0; $i < count($aDataTableDetailHTML); $i++) {
				$temp = '';
				for($j = 0; $j < count($aDataTableHeaderHTML); $j++) {
					$temp .= $aDataTableDetailHTML[$i][$j]."\t";
				}
				$reply .= trim($temp)."\n";
			}

			return $reply;
		}
		
		return false;
	}
	function trimblanklines($str) {
		return preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\r\n", $str);
	}
	function extractReply($string) {
		$start_tag = 'Ref :';
		$end_tag = 'Backup End Time';
		$found = false;
		$array = array();
		
		$lines = explode("\n", $string);
		
		foreach ($lines as $line) {
			if (strpos($line, $start_tag) !== FALSE || ($found && trim(preg_replace('/\s+/', ' ', $line)) != '')) {
				$found = true;
				$array[] = $line;
			}
			
			if (strpos($line, $end_tag) !== FALSE) {$found = false;}
		}
		//echo '<pre>';print_r($array);exit;
		if(count($array) > 0) {
			$reply = implode('', $array);
			$reply = trim($this->trimblanklines($reply));
			//preg_replace("/(^[\r\n]*|[\r\n]+)[\s\t]*[\r\n]+/", "\n", $reply);
			//echo '<pre>';print_r($reply);exit;
			return $reply;
		} else return false;
	}
	
	function viewJDisk($supp_obj, $a_predefined, $generic_msg, $status_msg, $content) {
		$cannedreplies = $supp_obj->prefix_table("cannedreplies");
		$canneddept = $supp_obj->prefix_table("canneddept");
		$staff_departments = $supp_obj->prefix_table("staff_departments");
		$tickets = $supp_obj->prefix_table("tickets");
		$clients = $supp_obj->prefix_table("clients");
		$client_custom_values = $supp_obj->prefix_table("client_custom_values");
		
		$template = "../templates/admin/jungledisk_canned.tpl";
		$content = $supp_obj->return_file_content($template);
		
		$select_field = 'custom_7';
		$select_email = 'noreply@jungledisk.com';
		$subject = 'Daily Backup Report';
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
				
		if($a_predefined['status_msg'] == "") {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		}
		
		$sql = "SELECT t.* FROM ".$clients." AS c LEFT JOIN ".$tickets." AS t ON c.client_id = t.client_id WHERE c.email = '".$select_email."' AND t.status != 'C'";
		$rows = $supp_obj->get_rsltset($sql);
		
		$nf_tickets = $nr_tickets = array();
		foreach($rows as $index => $row) {
			$computer_name = $this->extractJDName($row['message'], $supp_obj);
			//$this->debug($computer_name);
			if($computer_name) {
				$reply = $this->extractJDReply($row['message'], $supp_obj);
				if($reply) {
					$where_array = array();
					foreach($computer_name as $computer) {
						$where_array[] = " custom_7 LIKE  '%".$computer."%' ";
					}
					$where_clause = implode(' OR ', $where_array);
					$sql = "SELECT * FROM ".$client_custom_values." AS cv LEFT JOIN ".$clients." AS c ON cv.client_id = c.client_id WHERE ".$where_clause;
					//echo $sql.'<br><br><br>';
					$client_data = $supp_obj->get_a_line($sql);
					
					if(isset($client_data['client_id'])) {
						$return .= '<tr>';
							$return .= '<td height="35"><input type="hidden" name="ticket_id[]" value="'.$row['ticket_id'].'"><a href="ticket_detail.php?ticket_id='.$row['ticket_id'].'">'.$row['ticket_id'].'</a></td>';
							$return .= '<td>'.$client_data['email'].'<input type="hidden" name="client_id[]" value="'.$client_data['client_id'].'"><input type="hidden" name="client_name[]" value="'.$client_data['client_name'].'"><input type="hidden" name="email[]" value="'.$client_data['email'].'"></td>';
							$return .= '<td><input type="hidden" name="subject[]" value="'.$subject.'" class="form-control">'.$subject.'</td>';
							$return .= '<td>'.implode(', ', $computer_name).'</td>';
							$return .= '<td><input type="text" name="duration[]" size="5" value="20" class="form-control" /></td>';
						$return .= '</tr>';
						$return .= '<tr>';
							$return .= '<td colspan="5"><textarea class="form-control" name="reply[]">'.$reply.'</textarea></td>';
						$return .= '</tr>';
						
					} else {
						//customer not set
						$nr_tickets[$index]['ticket_id'] = $row['ticket_id'];
						$nr_tickets[$index]['client_id'] = '-';
						$nr_tickets[$index]['email'] = '-';
						$nr_tickets[$index]['computer_name'] = implode(', ', $computer_name);
						$nr_tickets[$index]['reply'] = $reply;
					}
					
				} else {
					//couldn't extract reply
					$nr_tickets[$index]['ticket_id'] = $row['ticket_id'];
					$nr_tickets[$index]['client_id'] = $client_data['client_id'];
					$nr_tickets[$index]['email'] = $client_data['email'];
					$nr_tickets[$index]['computer_name'] = implode(', ', $computer_name);
					$nr_tickets[$index]['reply'] = '-';
				}
			} else {
				//computer name not found
				$nr_tickets[$index]['ticket_id'] = $row['ticket_id'];
				$nr_tickets[$index]['client_id'] = '-';
				$nr_tickets[$index]['email'] = '-';
				$nr_tickets[$index]['computer_name'] = '-';
				$nr_tickets[$index]['reply'] = $reply;
			}
		}
		
		if(count($nr_tickets) == 0) {
			$content = preg_replace("/\<\{untickets_start\}\>(.*?)\<\{untickets_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{untickets_(.*?)\}\>/is", "", $content);
		}
		
		//unidentified tickets
		$untickets = '';
		foreach($nr_tickets as $index => $row) {
			$untickets .= '<tr>
                  <td><a href="ticket_detail.php?ticket_id='.$row['ticket_id'].'">'.$row['ticket_id'].'</a></td>
                  <td>'.$row['email'].'</td>
                  <td>'.$row['computer_name'].'</td>
                </tr>';
			/*$untickets .= '<tr>';
				$untickets .= '<td colspan="3"><textarea class="form-control">'.$row['reply'].'</textarea></td>';
			$untickets .= '</tr>';*/
		}
		
		$replace_array['unticketsloopdata'] = $untickets;
		$replace_array['ticketsloopdata'] = $return;
		$content = $supp_obj->direct_replace($content, $replace_array, $status_msg);
		
		echo $content;
	}
	//ibackup tickets
	function viewiBackup($supp_obj, $a_predefined, $generic_msg, $status_msg, $content) {
		$cannedreplies = $supp_obj->prefix_table("cannedreplies");
		$canneddept = $supp_obj->prefix_table("canneddept");
		$staff_departments = $supp_obj->prefix_table("staff_departments");
		$tickets = $supp_obj->prefix_table("tickets");
		$clients = $supp_obj->prefix_table("clients");
		$client_custom_values = $supp_obj->prefix_table("client_custom_values");
		
		$template = "../templates/admin/ibackup_canned.tpl";
		$content = $supp_obj->return_file_content($template);
		
		$select_field = 'custom_6';
		$select_email = 'no-reply@ibackup.com';
		$subject = 'Backup - Any Backup Related';
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
				
		if($a_predefined['status_msg'] == "") {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		}
		
		$sql = "SELECT t.* FROM ".$clients." AS c LEFT JOIN ".$tickets." AS t ON c.client_id = t.client_id WHERE c.email = '".$select_email."' AND t.status != 'C'";
		$rows = $supp_obj->get_rsltset($sql);
		
		$nf_tickets = $nr_tickets = array();
		
		foreach($rows as $index => $row) {
			$computer_name = $this->extractName($row['message']);
			
			if($computer_name) {
				$reply = $this->extractReply($row['message']);
				if($reply) {
					$sql = "SELECT * FROM ".$client_custom_values." AS cv LEFT JOIN ".$clients." AS c ON cv.client_id = c.client_id WHERE custom_6 LIKE '%".$computer_name."%'";
					$client_data = $supp_obj->get_a_line($sql);
					
					if(isset($client_data['client_id'])) {
						$return .= '<tr>';
							$return .= '<td height="35"><input type="hidden" name="ticket_id[]" value="'.$row['ticket_id'].'"><a href="ticket_detail.php?ticket_id='.$row['ticket_id'].'">'.$row['ticket_id'].'</a></td>';
							$return .= '<td>'.$client_data['email'].'<input type="hidden" name="client_id[]" value="'.$client_data['client_id'].'"><input type="hidden" name="client_name[]" value="'.$client_data['client_name'].'"><input type="hidden" name="email[]" value="'.$client_data['email'].'"></td>';
							$return .= '<td><input type="hidden" name="subject[]" value="'.$subject.'" class="form-control">'.$subject.'</td>';
							$return .= '<td>'.$computer_name.'</td>';
							$return .= '<td><input type="text" name="duration[]" size="5" value="20" class="form-control" /></td>';
						
						$return .= '</tr>';
						$return .= '<tr>';
							$return .= '<td colspan="5"><textarea class="form-control" name="reply[]">'.$reply.'</textarea></td>';
						$return .= '</tr>';
						
					} else {
						//customer not set
						$nr_tickets[$index]['ticket_id'] = $row['ticket_id'];
						$nr_tickets[$index]['client_id'] = '-';
						$nr_tickets[$index]['email'] = '-';
						$nr_tickets[$index]['computer_name'] = $computer_name;
						$nr_tickets[$index]['reply'] = $reply;
					}
					
				} else {
					//couldn't extract reply
					$nr_tickets[$index]['ticket_id'] = $row['ticket_id'];
					$nr_tickets[$index]['client_id'] = $client_data['client_id'];
					$nr_tickets[$index]['email'] = $client_data['email'];
					$nr_tickets[$index]['computer_name'] = $computer_name;
					$nr_tickets[$index]['reply'] = '-';
				}
			} else {
				//computer name not found
				$nr_tickets[$index]['ticket_id'] = $row['ticket_id'];
				$nr_tickets[$index]['client_id'] = '-';
				$nr_tickets[$index]['email'] = '-';
				$nr_tickets[$index]['computer_name'] = '-';
				$nr_tickets[$index]['reply'] = $reply;
			}
		}
		
		if(count($nr_tickets) == 0) {
			$content = preg_replace("/\<\{untickets_start\}\>(.*?)\<\{untickets_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{untickets_(.*?)\}\>/is", "", $content);
		}
		
		//unidentified tickets
		$untickets = '';
		foreach($nr_tickets as $index => $row) {
			$untickets .= '<tr>
                  <td><a href="ticket_detail.php?ticket_id='.$row['ticket_id'].'">'.$row['ticket_id'].'</a></td>
                  <td>'.$row['email'].'</td>
                  <td>'.$row['computer_name'].'</td>
                </tr>';
			/*$untickets .= '<tr>';
				$untickets .= '<td colspan="3"><textarea class="form-control">'.$row['reply'].'</textarea></td>';
			$untickets .= '</tr>';*/
		}
		
		$replace_array['unticketsloopdata'] = $untickets;
		$replace_array['ticketsloopdata'] = $return;
		$content = $supp_obj->direct_replace($content, $replace_array, $status_msg);
		
		echo $content;
	}
	//
	function reassignTicket($supp_obj, $a_predefined, $staff_id, $generic_msg, $manager) {
		//$this->debug($a_predefined);continue;
		$post_vars = $a_predefined['post'];
		$file_vars = $a_predefined['file'];
		$session_vars = $a_predefined['session'];		
		$zone = $session_vars['zone'];
		@extract($post_vars);

		if($reply == "")
			return false;

		$addresses = array();

		//Prefix and prepare tables 
		$tickets			=	$supp_obj->prefix_table("tickets");
		$staff_departments	=	$supp_obj->prefix_table("staff_departments");
		$staff				=	$supp_obj->prefix_table("staff");
		$clients			=	$supp_obj->prefix_table("clients");
		$mail_servers		=	$supp_obj->prefix_table("mail_servers");
		$dept_servers		=	$supp_obj->prefix_table("dept_servers");
		$config				=	$supp_obj->prefix_table("configuration");
		$departments		=	$supp_obj->prefix_table("departments");
		$emails				=	$supp_obj->prefix_table("emails");

		// Get the ticket details
		$sql = "select *,".$supp_obj->add_offsetNformat('sent_date',$zone,'minute','sent_date')." from $tickets where ticket_id='$ticket_id' ";			
		$a_ticket = $supp_obj->get_a_line($sql);
		$dept_id = $a_ticket['dept_id'];
		$client_id = $a_ticket['client_id'];
		$priority_id = $a_ticket['priority_id'];

		$sql=  "select * from $config ";
		$a_config = $supp_obj->get_a_line($sql);
		@extract($a_config);

		$ticket_reply_message = $ticket_replies;
		
		// Get the reply subject
		if($subject == "") {
			$subject1 = $a_config['reply_subject'];
			$subject = $a_ticket['subject'];
			$subject = addslashes ($subject);
			//$subject = preg_replace("/{{(.*?)}}/e","$$1",$subject1);
			preg_match_all("/{{(.*?)}}/", $subject1, $matches);
			$tmp_array = array();
			foreach ($matches[0] as $index => $var_name) {
				$tmp_var_name = $matches[1][$index];
				if (isset($$tmp_var_name)) {
					$tmp_array[$tmp_var_name] = $$tmp_var_name;
				} else {
					$tmp_array[$tmp_var_name] = '';
				}
			}
			
			$subject = preg_replace_callback("/{{(.*?)}}/",
								 function($m) use($tmp_array) { return $tmp_array[$m[1]]; },
								 $subject1);
		}
		
		//Get the mail server's email address and the signature of the department
		$sql="select pop3_email,signature,$departments.dept_name as dept_name from $mail_servers ,
			$dept_servers,$departments where 
			$mail_servers.server_id=$dept_servers.server_id 
			and $departments.dept_id=$dept_servers.dept_id
			and $dept_servers.dept_id='$dept_id' ";
		$a_from = $supp_obj->get_a_line($sql);	
		
		$from = $a_from['pop3_email'];
		$dept_name = $a_from['dept_name'];
		$from = $dept_name. " <".$from.">";
		$signature = $a_from['signature'];
		
		//Get the customer's email address
		$sql = "select * from $clients where client_id='$client_id' ";
		$a_client = $supp_obj->get_a_line($sql);
		$email = $a_client['email'];
		$client_name = $a_client['client_name'];
		
		$sql = "select is_admin,staff_signature from $staff where staff_id='$staff_id' ";
		$a_sql = $supp_obj->get_a_line($sql);
		$staff_signature = $a_sql['staff_signature'];
		$is_admin = $a_sql['is_admin'];		
		
		$sql = "select dept_id from $staff_departments where staff_id='$staff_id' ";
		$a_column = $supp_obj->get_single_column($sql);		
		//print_R($a_column);
		if(!$is_admin) {
			if(!in_array($dept_id, $a_column)) {
				return ;
			}
		}
		
		if($ticket_id != "") {
			$ticket_replies = $supp_obj->prefix_table("ticket_replies");
			$replied_on = $supp_obj->get_current_date();	
			$tktstatus = 'O';
			$action_array = array("N","O","H","C","S");
			if($dotktaction != "" and in_array($dotktaction,$action_array)) {
				$tktstatus = $dotktaction;
			}
		
			if($tktstatus == "C") {
				$supp_obj->notify_onticketclose($session_vars,$dept_id,$tktstatus,$ticket_id);
			}

			if($reply_minutes == "" or !is_numeric($reply_minutes)) {
				$reply_minutes = 0;
			}
			
			if($distance_reply == "" or !is_numeric($distance_reply)) {
				$distance_reply = 0;
			}
			
			if(isset($ctravelling)) {
				$remoteaccess = 1;
			} else {
				$remoteaccess = 0;
			}
			
			//$reply = strip_tags($reply);
			$insert_array = array("reply"=>addslashes($reply),"reporter_id"=>$staff_id,"private"=>'1',
								"ticket_id"=>$ticket_id,"reporter"=>"STAFF","replied_on"=>$replied_on,
								"subject"=>$subject,"change_status"=>$tktstatus,"reply_minutes"=>$reply_minutes,"reply_travel"=>$distance_reply,
								"responded_from"=>$dept_id,"source"=>$source,"destination"=>$destination,"remoteoption"=>$remoteaccess);
								
			$avoid_array = array("reply_id","reminder_on","last_update","last_updatedby","last_reporter");
			$sql = $supp_obj->construct_query($ticket_replies,"INSERT",$insert_array,$avoid_array);
			$reply_id = $supp_obj->execute_query($sql);
			
			$activity_array1['ticket_id'] = $ticket_id;
			$activity_array1['reply_id'] = $reply_id;
			
			$supp_obj->log_activity($activity_array1, $staff_id, 'STAFF', 'Y');
			
			$last_activity = $supp_obj->get_current_date();	
			$sql = "update $tickets set status='$tktstatus',
					subject='$subject',
					staff_last_activity='$last_activity',
					updater_id='$staff_id',updater='STAFF' where ticket_id='$ticket_id' ";
			$supp_obj->execute_query($sql);		
			
			$activity_array2['ticket_id'] = $ticket_id;
			$activity_array2['status'] = $tktstatus;
			
			//mark reply
			$manager->mark_as_resolution($supp_obj, $ticket_id, $reply_id);
			
			// Log status change only if the status is different from the previous status. Change done on version 3.0.0
			if($a_ticket['status'] != $tktstatus) {
				$supp_obj->log_activity($activity_array2, $staff_id, 'STAFF');
			}
			
			$current_status = $supp_obj->get_status_name($tktstatus);
			$current_priority = $supp_obj->get_priority_name($priority_id);
		}
	}
	function validate ($supp_obj, $a_predefined, $client_email) {
		$clients=$supp_obj->prefix_table("clients");
		$sql = "select client_id from $clients where email = '$client_email'";
		$query_result = $supp_obj->get_a_line ($sql);
		if ($query_result [0] == NULL) {
			return "new customer";
		} else {
			return "existing customer";
		}
	}
	function reassign_ticket ($a_predefined, $supp_obj, $generic_msg, $client_name, $client_email, $ticket_id) {
		$validate = $this->validate ($supp_obj, $a_predefined, $client_email);
		
		// get the old client id (for updating the activity table)
		$tickets=$supp_obj->prefix_table("tickets");
		$clients=$supp_obj->prefix_table("clients");
		$sql = "select client_id from $tickets where ticket_id = '$ticket_id'";
		$query_result = $supp_obj->get_a_line ($sql);
		$old_client_id = $query_result [0];
		if ($validate == "new customer") {
			// create a new client
			$sql = "insert into $clients ";
			$sql = $sql."(client_name, email,client_status) values ('$client_name', '$client_email','a')";
			$supp_obj -> execute_query ($sql);
		}
		if ($validate == "existing customer") {
			// update the existing record of the customer
			$sql = "update $clients set client_name = '$client_name' where email = '$client_email'";
			$supp_obj->execute_query ($sql);
		}
		// get the client id of the new client
		$sql = "select client_id from $clients where email = '$client_email'";
		$query_result = $supp_obj->get_a_line ($sql);
		$client_id    = $query_result [0];
		// update the existing record in the tickets table to point to the new customer

		$sql = "update $tickets set client_id = '$client_id' where ticket_id = '$ticket_id'";
		$supp_obj->execute_query ($sql);
		// update the ticket replies table. set the reporter_id to the current client id, 
		// only where the reporter type is CLIENT
		$ticket_replies=$supp_obj->prefix_table("ticket_replies");
		$sql = "update $ticket_replies set reporter_id = '$client_id' ";
		$sql = $sql."where ticket_id = '$ticket_id' and reporter = 'CLIENT'";
		$supp_obj->execute_query ($sql);
		// insert a new record in the activity table
		$dateTime = $supp_obj->get_current_date ();
		$staff_id = $_SESSION['staff_id'];
		$activity_log=$supp_obj->prefix_table("activity_log");
		
		$sql = "insert into $activity_log (action_on, action_by, action_who, ticket_id, action_name, action_detail,
			adept_id, areply_id, astatus) ";
		$sql = $sql." values ('$dateTime', '$staff_id', 'STAFF', '$ticket_id', 'REASSIGN', '$old_client_id => $client_id',
			'', '', '')";

		$supp_obj->execute_query ($sql);
		$return_array['status_msg'] = $generic_msg['cReassign_customer']; 
		
		return $return_array;
	}
	
	function closeTickets($supp_obj, $a_predefined, $generic_msg, $status_msg, $manager, $type_backup = 'ibackup') {
		$cannedreplies = $supp_obj->prefix_table("cannedreplies");
		$canneddept = $supp_obj->prefix_table("canneddept");
		$staff_departments = $supp_obj->prefix_table("staff_departments");
		$tickets = $supp_obj->prefix_table("tickets");
		$activity_log = $supp_obj->prefix_table("activity_log");
		$clients = $supp_obj->prefix_table("clients");
		
		$post_vars = $a_predefined['post'];
		$get_vars = $a_predefined['get'];
		$session_vars = $a_predefined['session'];	
				
		if($a_predefined['status_msg'] == "") {
			$content = preg_replace("/\<\{errormsg_start\}\>(.*?)\<\{errormsg_end\}\>/is", "", $content);		
		} else {
			$content = preg_replace("/\<\{errormsg_(.*?)\}\>/is", "", $content);
		}
		
		$staff_id = $session_vars['staff_id'];
		
		for($i = 0; $i < count($post_vars['ticket_id']); $i++) {
			if($post_vars['reply'][$i] == '') continue;
			if($post_vars['email'][$i] == '') continue;
			if($post_vars['client_name'][$i] == '') continue;
			if($post_vars['ticket_id'][$i] == '') continue;
			
			$check = array();
			$sql = "SELECT * FROM ".$tickets." WHERE ticket_id = '".$post_vars['ticket_id'][$i]."' AND status != 'C'";
			$check = $supp_obj->get_a_line($sql);
			
			if(isset($check['ticket_id'])) {
				$ticket = array();
				$ticket['post']['subject'] = $post_vars['subject'][$i];
				$ticket['post']['reply'] = $post_vars['reply'][$i];
				$ticket['post']['ticket_id'] = $post_vars['ticket_id'][$i];
				$ticket['post']['reply_minutes'] = $post_vars['duration'][$i];
				$ticket['post']['dotktaction'] = 'C';
				$ticket['session'] = $session_vars;
				
				if($this->reassign_ticket($a_predefined, $supp_obj, $generic_msg, $post_vars['client_name'][$i], $post_vars['email'][$i], $post_vars['ticket_id'][$i])) {
					$this->reassignTicket($supp_obj, $ticket, $staff_id, $generic_msg, $manager);
				}
			}
		}
		header('Location: ibackup_tickets.php?act='.$type_backup.'&status=updated');exit;
	}
	
}

$cc = new ibackupClose;
$act = $get_vars['act'];

switch($act) {
	case "ibackup":
		$cc->viewiBackup($supp_obj, $a_predefined, $generic_msg, $status_msg);
	break;
	case "jungledisk":
		$cc->viewJDisk($supp_obj, $a_predefined, $generic_msg, $status_msg);
	break;
	case "close":
		$cc->closeTickets($supp_obj, $a_predefined, $generic_msg, $status_msg, $manager, 'ibackup');
	break;	
	case "jdclose":
		$cc->closeTickets($supp_obj, $a_predefined, $generic_msg, $status_msg, $manager, 'jungledisk');
	break;
}
include_once("footer.php");
?>