<?php
ob_start();
session_name("supportadmin");
session_start();
if (!defined('ROOT_PATH'))
	define('ROOT_PATH', $_SESSION['path']);

require_once ROOT_PATH . '/lib/models/benefits/Hsp.php';
require_once ROOT_PATH . '/lib/models/benefits/mail/HspMailNotification.php';

try {
	$hspSummaryId 	= $_GET['hspSummaryId'];
	$newHspStatus   = $_GET['newHspStatus'];
	$empId		= $_GET['empId'];

	$hsp = new Hsp();
	$hsp->setEmployeeId($empId);
	$hsp->setSummaryId($hspSummaryId);
	$hsp->setHspPlanStatus($newHspStatus);

	$hspMailNotification = new HspMailNotification();

	if(Hsp::updateStatus($hspSummaryId, $newHspStatus)) {
		switch ($newHspStatus) {
			case Hsp::HSP_STATUS_HALTED :
				$hspMailNotification -> sendHspPlanHaltedByHRAdminNotification($hsp);
				break;
			case Hsp::HSP_STATUS_ACTIVE :
				break;
			case Hsp::HSP_STATUS_ESS_HALTED :
				$hspMailNotification -> sendHspPlanHaltedByHRAdminOnRequestNotification($hsp);
				break;
			case Hsp::HSP_STATUS_PENDING_HALT :
				$hspMailNotification->sendHspPlanHaltRequestedByESSNotification($hsp);
				break;
		}
		echo 'done:'. $newHspStatus;
	} else {
		echo 'fail:Error while changing the new HSP status';
	}
} catch(Exception $e) {
	echo 'fail:Error while performing the requested action';
}
?>
