<?php
require_once ROOT_PATH . '/lib/confs/Conf.php';
require_once ROOT_PATH . '/lib/dao/DMLFunctions.php';
require_once ROOT_PATH . '/lib/dao/SQLQBuilder.php';
require_once ROOT_PATH . '/lib/common/CommonFunctions.php';
require_once ROOT_PATH . '/lib/common/UniqueIDGenerator.php';

class PayPeriod {

	const TABLE_NAME = "hs_hr_payperiod";
	const DB_FIELD_PAYPERIOD_CODE = "payperiod_code";
	const DB_FIELD_PAYPERIOD_NAME = "payperiod_name";

	private $code;
	private $name;

	public function __construct() {
	}

	public function setCode($code) {
		$this->code = $code;
	}

	public function getCode() {
		return $this->code;
	}

	public function setName($name) {
		$this->name = $name;
	}

	public function getName() {
		return $this->name;
	}

	/**
	 * Get list of pay periods defined in the system
	 * @return array Array of all pay periods defined in the system
	 */
	public static function getPayPeriodList() {

		$fields[0] = self::DB_FIELD_PAYPERIOD_NAME;
		$fields[1] = self::DB_FIELD_PAYPERIOD_CODE;

		$sql_builder = new SQLQBuilder();

		$sql_builder->table_name = self::TABLE_NAME;
		$sql_builder->flg_select = 'true';
		$sql_builder->arr_select = $fields;

		$sql = $sql_builder->queryAllInformation();

		$dbConnection = new DMLFunctions();
		$result = $dbConnection->executeQuery($sql);

		$periods = array();

		if ($result && mysql_num_rows($result) > 0) {
			while($line = mysql_fetch_assoc($result)) {;
				$period = new PayPeriod();
				$period->setCode($line[self::DB_FIELD_PAYPERIOD_CODE]);
				$period->setName($line[self::DB_FIELD_PAYPERIOD_NAME]);
				$periods[$period->getCode()] = $period;
			}
		}

		return $periods;
	}
}

?>
