<?php
require_once ROOT_PATH . '/lib/common/Config.php';

class DefineHsp {
	public function __construct() {

	}

	public function setConfigValue($KeyHsp, $valueHsp) {
		Config::setHspCurrentPlan($KeyHsp, $valueHsp);
	}

	public function getConfigValue() {
		return Config::getHspCurrentPlan();
	}


	public static function fetchHsp($hspType = null) {
		return Config::getHspCurrentPlan();
	}

	/**
	 * Returns the HSP plan name based on the given HSP plan ID
	 */

	public static function getHspPlanName($hspPlanId) {

		switch ($hspPlanId) {

			case 1:
				$hspPlanName = "HSA";
				break;
			case 2:
				$hspPlanName = "HRA";
				break;
			case 3:
				$hspPlanName = "FSA";
				break;
			case 4:
				$hspPlanName = "HSA+FSA";
				break;
			case 5:
				$hspPlanName = "HRA+FSA";
				break;
			case 6:
				$hspPlanName = "HSA+HRA";
				break;

		}

		return $hspPlanName;

	}

	public static function getHspPlanId($hspPlanName) {

		switch ($hspPlanName) {

			case "HSA":
				$hspPlanId = 1;
				break;
			case "HRA":
				$hspPlanId = 2;
				break;
			case "FSA":
				$hspPlanId = 3;
				break;

		}

		return $hspPlanId;
	}

}
?>
