<?php
 require_once ROOT_PATH . '/lib/models/recruitment/JobApplicationEvent.php';

 class EXTRACTOR_ScheduleInterview {

	/**
	 * Parse data from interface and return JobApplicationEvent Object
	 * @param Array $postArr Array containing POST values
	 * @return JobApplicationEvent Job Application Event object
	 */
	public function parseAddData($postArr) {

		$event = new JobApplicationEvent();

        $id = $postArr['txtId'];
        $event->setApplicationId($id);

        $date = $postArr['txtDate'];
        $time = $postArr['txtTime'];
        $dateTime = LocaleUtil::getInstance()->convertToStandardDateTimeFormat($date . ' ' . $time);
        $event->setEventTime($dateTime);

        $interviewer = $postArr['cmbInterviewer'];
        $event->setOwner($interviewer);

        $notes = $postArr['txtNotes'];
        $event->setNotes($notes);

        return $event;
	}

}
?>