<?php
require_once ROOT_PATH . '/lib/models/leave/LeaveRequests.php';

class EXTRACTOR_Leave {

	private $parent_Leave;

	function __construct() {
		$this->parent_Leave = new LeaveRequests();
	}

	public function parseAddData($postArr) {

		// Extract dates
		$postArr['txtLeaveFromDate'] = LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtLeaveFromDate']);
		$postArr['txtLeaveToDate'] = LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtLeaveToDate']);

		$this->parent_Leave->setEmployeeId($_SESSION['empID']);
		$this->parent_Leave->setLeaveTypeId($postArr['sltLeaveType']);
		$this->parent_Leave->setLeaveFromDate($postArr['txtLeaveFromDate']);

		if (isset($postArr['txtLeaveToDate']) && !empty($postArr['txtLeaveToDate'])) {
			$this->parent_Leave->setLeaveToDate($postArr['txtLeaveToDate']);
		} else {
			$this->parent_Leave->setLeaveToDate($postArr['txtLeaveFromDate']);
		}

		$this->parent_Leave->setLeaveLength($postArr['sltLeaveLength']);
		$this->parent_Leave->setLeaveComments($postArr['txtComments']);

		return $this->parent_Leave;
	}


	/**
	 * Pares edit data in the UI form
	 *
	 * @param mixed $postArr
	 * @return Leave[]
	 */
	public function parseEditData($postArr) {

		$objLeave = null;

		if (isset($postArr['cmbStatus'])) {
			for ($i=0; $i < count($postArr['cmbStatus']); $i++) {
				$tmpObj = new Leave();
				$tmpObj->setLeaveId($postArr['id'][$i]);
				$tmpObj->setLeaveStatus($postArr['cmbStatus'][$i]);
				$tmpObj->setLeaveComments($postArr['txtComment'][$i]);

				if (isset($postArr['txtEmployeeId'][$i])) {
					$tmpObj->setEmployeeId($postArr['txtEmployeeId'][$i]);
					$tmpObj->setEmployeeName($postArr['txtEmployeeName'][$i]);
				}

				$tmpObj->setLeaveTypeName($postArr['txtLeaveTypeName'][$i]);
				$tmpObj->setLeaveRequestId($postArr['txtLeaveRequestId'][$i]);

				$objLeave[] = $tmpObj;
			}
		}

		return $objLeave;
	}

	/**
	 * Pares delete data in the UI form
	 *
	 * @param mixed $postArr
	 * @return Leave[]
	 */
	public function parseDeleteData($postArr) {
		$objLeave = null;

		if (isset($postArr['cmbStatus'])) {
			for ($i=0; $i < count($postArr['cmbStatus']); $i++) {
				$tmpObj = new Leave();
				$tmpObj->setLeaveId($postArr['id'][$i]);
				$tmpObj->setLeaveComments($postArr['txtComment'][$i]);
				$tmpObj->setEmployeeId($postArr['txtEmployeeId'][$i]);
				$tmpObj->setLeaveStatus($postArr['cmbStatus'][$i]);
				$tmpObj->setLeaveRequestId($postArr['txtLeaveRequestId'][$i]);

				$objLeave[] = $tmpObj;
			}
		}

		return $objLeave;
	}

}
?>