<?php
require_once ROOT_PATH . '/lib/models/leave/Holidays.php';

class EXTRACTOR_Holidays {

	private $parent_Holidays;

	public function __construct() {
		$this->parent_Holidays = new Holidays();
	}

	public function parseAddData($postArr) {

		$postArr['txtDate'] = LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtDate']);

		$this->parent_Holidays->setDescription($postArr['txtDescription']);
		$this->parent_Holidays->setDate($postArr['txtDate']);

		if (isset($_POST['chkRecurring'])) {
			$this->parent_Holidays->setRecurring($postArr['chkRecurring']);
		} else {
			$this->parent_Holidays->setRecurring(Holidays::HOLIDAYS_NOT_RECURRING);
		}

		$this->parent_Holidays->setLength($postArr['sltLeaveLength']);

		return $this->parent_Holidays;
	}


	/**
	 * Pares edit data in the UI form
	 *
	 * @param mixed $postArr
	 * @return Leave[]
	 */
	public function parseEditData($postArr) {

		$postArr['txtDate'] = LocaleUtil::getInstance()->convertToStandardDateFormat($postArr['txtDate']);

		if (isset($_POST['txtId']) && !empty($postArr['txtId'])) {
			$this->parent_Holidays->setHolidayId($postArr['txtId']);
		}

		$this->parent_Holidays->setDescription($postArr['txtDescription']);
		$this->parent_Holidays->setDate($postArr['txtDate']);

		if (isset($postArr['chkRecurring'])) {
			$this->parent_Holidays->setRecurring($postArr['chkRecurring']);
		} else {
			$this->parent_Holidays->setRecurring(Holidays::HOLIDAYS_NOT_RECURRING);
		}

		$this->parent_Holidays->setLength($postArr['sltLeaveLength']);

		return $this->parent_Holidays;
	}

	/**
	 * Pares delete data in the UI form
	 *
	 * @param mixed $postArr
	 * @return Leave[]
	 */
	public function parseDeleteData($postArr) {
		$objLeave = null;

		if (isset($postArr['deletHoliday'])) {
			for ($i=0; $i < count($postArr['deletHoliday']); $i++) {
				if (!empty($postArr['deletHoliday'][$i])) {
					$tmpObj = new Holidays();
					$tmpObj->setHolidayId($postArr['deletHoliday'][$i]);

					$objLeave[] = $tmpObj;
				}
			}
		}

		return $objLeave;
	}

}
?>