<?php
require_once ROOT_PATH . '/lib/models/eimadmin/JobTitle.php';

class EXTRACTOR_JobTitle {

	function EXTRACTOR_JobTitle() {
	}

	function parseAddData($postArr) {
        return $this->_parseCommonData($postArr);
	}

	function parseEditData($postArr) {
        $jobTitle = $this->_parseCommonData($postArr);
        $jobTitle->setJobId($postArr['txtJobTitleID']);
		return $jobTitle;
	}

    /**
     * Parse common data for edit and update
     * @return JobTitle object
     */
    private function _parseCommonData($postArr) {
        $jobTitle = new JobTitle();
        $jobTitle->setJobName(CommonFunctions::escapeHtml(trim($postArr['txtJobTitleName'])));
        $jobTitle->setJobDesc(CommonFunctions::escapeHtml(trim($postArr['txtJobTitleDesc'])));
        $jobTitle->setJobComm(CommonFunctions::escapeHtml(trim($postArr['txtJobTitleComments'])));
        $jobTitle->setJobSalGrd(trim($postArr['cmbPayGrade']));

        $jobSpecId = trim($postArr['cmbJobSpecId']);
        if (CommonFunctions::isValidId($jobSpecId)) {
            $jobTitle->setJobSpecId($jobSpecId);
        }

        return $jobTitle;
    }

}
?>
